
<script type="text/javascript">
    $('body').on('click', '.restore', function() {
        event.preventDefault();
        var tr = $(this).parent().parent();
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: 'btn btn-success',
                cancelButton: 'btn btn-danger'
            },
            buttonsStyling: false
        })
        swalWithBootstrapButtons.fire({
            title: '<?php echo app('translator')->get('common.are_you_sure_to_restore'); ?>',
            /*text: "You won't be able to recover this!",*/
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: '<?php echo app('translator')->get('common.yes_restore'); ?>',
            cancelButtonText: '<?php echo app('translator')->get('common.no_cancel'); ?>',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                event.preventDefault();
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: $(this).attr('href'),
                    type: 'GET',
                    dataType: 'JSON',
                    cache: false,
                    success: function(response) {
                        toastr["success"](response.message, "<?php echo app('translator')->get('common.restore_success'); ?>");
                        tr.remove();
                        window.location.reload()
                    },
                    error: function(xhr) {
                        toastr["error"]('<?php echo app('translator')->get('common.not_restored'); ?>', "<?php echo app('translator')->get('common.sorry'); ?>");
                    }
                });
            } else if (
                /* Read more about handling dismissals below */
                result.dismiss === Swal.DismissReason.cancel
            ) {
                toastr["error"]("<?php echo app('translator')->get('common.safe'); ?>", "<?php echo app('translator')->get('common.cancelled'); ?>");

            }
        })
    });
</script>


<script type="text/javascript">
    $(document).on('click', '.multiple_restore', function() {
        event.preventDefault();
        let url = $(this).attr('href')
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: 'btn btn-success',
                cancelButton: 'btn btn-danger'
            },
            buttonsStyling: false
        })
        var ids = [];
        $('.multi_checkbox:checked').each(function() {
            ids.push($(this).val());
        });
        if (ids.length > 0) {
            swalWithBootstrapButtons.fire({
                title: '<?php echo app('translator')->get('common.are_you_sure_to_restore'); ?>',
                /*text: "You won't be able to recover this!",*/
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: '<?php echo app('translator')->get('common.yes_restore'); ?>',
                cancelButtonText: '<?php echo app('translator')->get('common.no_cancel'); ?>',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: url,
                        type: 'post',
                        dataType: 'JSON',
                        cache: false,
                        data: {
                            ids: ids
                        },
                        success: function(response) {
                            toastr["success"](response.message, "<?php echo app('translator')->get('common.restore_success'); ?>");
                            $('#datatable').DataTable().ajax.reload();
                            $('#deleted_list_datatable').DataTable().ajax.reload();
                        },
                        error: function(xhr) {
                            toastr["error"]('<?php echo app('translator')->get('common.not_restored'); ?>', "<?php echo app('translator')->get('common.sorry'); ?>");
                        }
                    });
                } else if (
                    /* Read more about handling dismissals below */
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    toastr["error"]("<?php echo app('translator')->get('common.safe'); ?>", "<?php echo app('translator')->get('common.cancelled'); ?>");
                }
            })
        } else {
            swalWithBootstrapButtons.fire({
                title: "Failed !",
                text: 'Select at least one row',
                dangerMode: true,
                icon: "error",
                showConfirmButton: true,
                timer: 4000
            });
        }
    });
</script>
<?php /**PATH /home/gzmcfenigov/public_html/resources/views/components/restore_script.blade.php ENDPATH**/ ?>