<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($data['personal_info']->student_name); ?></title>
    <style>
        @page {
        size: A4;
        margin: 0;
        }
        table{
            width: 100%;
        }

        .full-paper-wrap::after{
            content: "";
            background-image:url(<?php echo e(asset($setting->image)); ?>);
            background-repeat:no-repeat;
            background-size:auto;
            background-position:center;
            /* z-index : 99 */
            position : absolute;
            top: 0px;
            right: 0px;
            bottom: 0px;
            left: 0px;
            opacity : 0.1;

        }

        table, tr, td{
            border: 1px solid black;
            border-collapse: collapse;
        }
        .full-paper-wrap{
            border: 1px solid black;
            /* width: 210mm; */
            /* height: 297mm; */
            margin: auto;
            padding : 10px;
        }
        .logo {
            float: left;
            margin-right: 65px;
            margin-left: 164px;
        }

        .name_adress {
            float: left;
            margin-top: 10px;
            font-size: 26px;
        }

        .name_adress span{
            font-size:20px
        }
        @media print {
        html, body {
            width: 210mm;
            height: 297mm;
        }
        /* ... the rest of the rules ... */
        }
    </style>
</head>
<body>

    <div class="full-paper-wrap" style="">
        <table>
                <tr>
                    <td style="height:90px;padding: 8px 5px;" colspan="6">
                        <div class="logo">
                            <img src="<?php echo e(asset($setting->image)); ?>" style="height: 80px;width:70px;">
                        </div>
                        <div class="name_adress" style="text-align: center">
                            <b><?php echo e($setting->name); ?></b><br>
                            <span><?php echo e($setting->address); ?></span>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 8px 5px;" colspan="6" style="text-align: center;padding:10px 8px;">
                        <b style="text-transform: uppercase;">Student Information</b>
                    </td>
                </tr>

                <tr>
                    <th style="padding: 8px 5px;">Present Year</th>
                    <td style="padding: 8px 5px;width:15%;"><?php echo e($data['running_info']->year); ?></td>
                    <th style="padding: 8px 5px;">Class</th>
                    <td style="padding: 8px 5px;"><?php echo e($data['running_info']->class_name); ?></td>
                    <th style="padding: 8px 5px;">Group</th>
                    <td style="padding: 8px 5px;"><?php echo e($data['running_info']->group_name); ?></td>
                </tr>

                <tr>
                    <th style="padding: 8px 5px;">Student ID</th>
                    <td style="padding: 8px 5px;"><?php echo e($data['running_info']->student_id); ?></td>
                    <th style="padding: 8px 5px;">Class Roll</th>
                    <td colspan="3" style="padding: 8px 5px;"><?php echo e($data['running_info']->class_roll); ?></td>
                </tr>

            <tr>
                <td style="padding: 8px 5px;" colspan="4">Session : <?php echo e($data['academic_information']->session2); ?></td>
                <td colspan="2" style="width: 20%;text-align:center;" rowspan="5">
                    
                <?php
                $path = base_path().'/ems/others_img/'.$data['running_info']->student_id.'.jpg';
                ?>
                <?php if(file_exists($path)): ?>
                <img src="<?php echo e(env('APP_URL').'/ems/others_img'); ?>/<?php echo e($data['running_info']->student_id.'.jpg'); ?>" alt="" style="height: 120px;width:120px;">
                <?php else: ?>
                <img src="https://media.istockphoto.com/id/1300845620/vector/user-icon-flat-isolated-on-white-background-user-symbol-vector-illustration.jpg?s=612x612&w=0&k=20&c=yBeyba0hUkh14_jgv1OKqIH0CCSWU_4ckRkAoy2p73o=" alt="" style="height:60px;width:60px;">
                <?php endif; ?>
                </td>
            </tr>
            <tr>
                <td style="padding: 8px 5px;width:15%;">Student Name</td>
                <td colspan="3" style="padding: 8px 5px;text-transform:uppercase;width:30%;"><?php echo e($data['personal_info']->student_name); ?></td>
            </tr>
            <tr>
                <td style="padding: 8px 5px;width:15%;">Father Name</td>
                <td  colspan="3"  style="padding: 8px 5px;text-transform:uppercase;"><?php echo e($data['personal_info']->father_name); ?></td>
            </tr>
            <tr>
                <td style="padding: 8px 5px;width:15%;">Mother Name</td>
                <td  colspan="3"  style="padding: 8px 5px;text-transform:uppercase;"><?php echo e($data['personal_info']->mother_name); ?></td>
            </tr>
            <tr>
                <td style="padding: 8px 5px;width:20%;">Permenant Adress</td>
                <td  colspan="3"  style="padding: 8px 5px;"><?php echo e($data['adress_information']->permanent_house_name); ?>,<?php echo e($data['adress_information']->permanent_village); ?>,<?php echo e($data['adress_information']->permanent_village); ?>,<?php echo e($data['adress_information']->permanent_PO); ?>,<?php echo e($data['adress_information']->permanent_post_code); ?>,<?php echo e($data['adress_information']->permanent_upazila); ?>,<?php echo e($data['adress_information']->permanent_distric); ?></td>
            </tr>
            <tr>
                <td style="padding: 5px 5px;">Date of birth</td>
                <td style="padding: 5px 5px;"><?php echo e($data['personal_info']->date_of_brith); ?></td>
                <td style="padding: 5px 5px;width:17%">Admission Date</td>
                <td colspan="3" style="padding: 5px 5px;"><?php echo e($data['personal_info']->addmission_date); ?></td>
            </tr>
            <tr>
                <td style="padding: 5px 5px;">Religion</td>
                <td style="padding: 5px 5px;"><?php echo e($data['personal_info']->religious); ?></td>
                <td style="padding: 5px 5px;width:17%">Gender</td>
                <td colspan="3" style="padding: 5px 5px;"><?php echo e($data['personal_info']->gender); ?></td>
            </tr>
            <tr>
                <td style="padding: 5px 5px;">Blood Group</td>
                <td style="padding: 5px 5px;"><?php echo e($data['personal_info']->blood_group); ?></td>
                <td style="padding: 5px 5px;width:17%">Contact Number</td>
                <td colspan="3" style="padding: 5px 5px;"><?php echo e($data['personal_info']->contact_no); ?></td>
            </tr>
            <tr>
                <td style="padding:10px 8px;text-transform:uppercase;" colspan="6"><b>Guardian Information</b></td>
            </tr>
            <tr>
                <td style="padding: 5px 5px;">Guardian name</td>
                <td style="padding: 5px 5px;"><?php echo e($data['guardian_info']->guardian_name); ?></td>
                <td style="padding: 5px 5px;width:17%">Guardian contact</td>
                <td colspan="3" style="padding: 5px 5px;"><?php echo e($data['guardian_info']->guardian_contact); ?></td>
            </tr>
            <tr>
                <td style="padding:10px 8px;text-transform:uppercase;" colspan="6"><b>Registered Subject</b></td>
            </tr>
            <tr>
                <td style="padding: 5px 5px;">Subject Code</td>
                <td style="padding: 5px 5px;width:80%" colspan="5">Subject Name</td>
            </tr>
            <tr>
                <td colspan="6" style="padding: 5px 8px;text-align:center;font-weight:bold;">Compulsory Subject</td>
            </tr>

            <?php if($subject): ?>
            <?php $__currentLoopData = $subject; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($s->select_subject_type == 'CompulsorySubject'): ?>
            <tr>
                <td style="padding: 5px 5px;"><?php echo e($s->subject_code); ?></td>
                <td style="padding: 5px 5px;" colspan="5"><?php echo e($s->subject_name); ?></td>
            </tr>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            <tr>
                <td colspan="6" style="padding: 5px 8px;text-align:center;font-weight:bold;">Group Subject</td>
            </tr>
            <?php if($subject): ?>
            <?php $__currentLoopData = $subject; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($s->select_subject_type == 'GroupSubject'): ?>
            <tr>
                <td style="padding: 5px 5px;"><?php echo e($s->subject_code); ?></td>
                <td style="padding: 5px 5px;" colspan="5"><?php echo e($s->subject_name); ?></td>
            </tr>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            <tr>
                <td colspan="6" style="padding: 5px 8px;text-align:center;font-weight:bold;">Optional Subject</td>
            </tr>
            <?php if($subject): ?>
            <?php $__currentLoopData = $subject; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($s->select_subject_type == 'OptionalSubject'): ?>
            <tr>
                <td style="padding: 5px 5px;"><?php echo e($s->subject_code); ?></td>
                <td style="padding: 5px 5px;" colspan="5"><?php echo e($s->subject_name); ?></td>
            </tr>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </table>
    </div>

</body>
</html>
<?php /**PATH /home/gzmcfenigov/public_html/resources/views/frontend/view_student_details.blade.php ENDPATH**/ ?>