<?php $__env->startPush('header_styles'); ?>
    <!-- third party css -->
    <link href="<?php echo e(asset('assets/css/vendor/dataTables.bootstrap5.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/css/vendor/responsive.bootstrap5.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/css/vendor/buttons.bootstrap5.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/css/vendor/select.bootstrap5.css')); ?>" rel="stylesheet" type="text/css">
    <!-- third party css end -->
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">

        <?php $__env->startComponent('components.breadcrumb'); ?>
            <?php $__env->slot('title'); ?>
                <?php echo app('translator')->get('role.role'); ?>
            <?php $__env->endSlot(); ?>
            <?php $__env->slot('breadcrumb1'); ?>
                <?php echo app('translator')->get('common.dashboard'); ?>
            <?php $__env->endSlot(); ?>
            <?php $__env->slot('breadcrumb1_link'); ?>
                <?php echo e(route('dashboard')); ?>

            <?php $__env->endSlot(); ?>
            <?php if(\App\Traits\RolePermissionTrait::checkRoleHasPermission('role', 'create')): ?>
                <?php $__env->slot('action_button1'); ?>
                    <?php echo app('translator')->get('common.add_new'); ?>
                <?php $__env->endSlot(); ?>
                <?php $__env->slot('action_button1_link'); ?>
                    <?php echo e(route('role.create')); ?>

                <?php $__env->endSlot(); ?>
            <?php endif; ?>
            <?php $__env->slot('action_button1_class'); ?>
                btn-primary
            <?php $__env->endSlot(); ?>
        <?php echo $__env->renderComponent(); ?>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="header-title"><?php echo app('translator')->get('role.index_title'); ?></h4>
                        <ul class="nav nav-tabs nav-bordered mb-3">
                            <li class="nav-item">
                                <a href="#roles-tab-all" data-bs-toggle="tab" aria-expanded="false" class="nav-link active">
                                    <?php echo app('translator')->get('common.all'); ?>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="#roles-tab-deleted" data-bs-toggle="tab" aria-expanded="true" class="nav-link">
                                    <?php echo app('translator')->get('common.deleted_list'); ?>
                                </a>
                            </li>
                        </ul> <!-- end nav-->
                        <div class="tab-content">
                            <div class="tab-pane show active" id="roles-tab-all">
                                <table id="datatable-roles-all" class="table table-striped dt-responsive nowrap w-100">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th><?php echo app('translator')->get('common.name'); ?></th>
                                            <th><?php echo app('translator')->get('common.status'); ?></th>
                                            <th><?php echo app('translator')->get('common.action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if($data): ?>
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($i++); ?></td>
                                            <td><?php echo e($v->name); ?></td>
                                            <td>
                                                <?php if($v->status == 1): ?>
                                                <span class="badge bg-success"><?php echo app('translator')->get('common.active'); ?></span>
                                                <?php else: ?>
                                                <span class="badge bg-danger"><?php echo app('translator')->get('common.inactive'); ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <a style="float: left" href="<?php echo e(route('role.edit',$v->id)); ?>" class="btn btn-sm btn-info"><i class="fa fa-edit"></i></a>
                                                <form method="post" action="<?php echo e(route('role.destroy',$v->id)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                <button onclick="return confirm('Are You Sure ?')" type="submit" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>
                                                </form>
                                                <a style="float: left" href="<?php echo e(url('role/'.$v->id.'/permission')); ?>" class="btn btn-sm btn-info"><i class="fa fa-lock"></i></a>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div> <!-- end all-->

                            <div class="tab-pane" id="roles-tab-deleted">
                                <table id="datatable-roles-deleted" class="table table-striped dt-responsive nowrap w-100">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th><?php echo app('translator')->get('common.name'); ?></th>
                                            <th><?php echo app('translator')->get('common.status'); ?></th>
                                            <th><?php echo app('translator')->get('common.action'); ?></th>
                                        </tr>
                                    </thead>
                                </table>
                            </div> <!-- end deleted-->
                        </div> <!-- end tab-content-->

                    </div> <!-- end card body-->
                </div> <!-- end card -->
            </div><!-- end col-->
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer_scripts'); ?>
    <!-- third party js -->
    <script src="<?php echo e(asset('assets/js/vendor/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor/dataTables.bootstrap5.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor/responsive.bootstrap5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor/buttons.bootstrap5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor/buttons.flash.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor/dataTables.keyTable.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor/dataTables.select.min.js')); ?>"></script>
    <!-- third party js ends -->

    <!-- demo app -->
    <script src="<?php echo e(asset('assets/js/pages/demo.datatable-init.js')); ?>"></script>
    <!-- end demo js-->



    <?php echo $__env->make('components.delete_script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gzmcfenigov/public_html/resources/views/role/index.blade.php ENDPATH**/ ?>