@extends('layouts.master')

@push('header_styles')
    <!-- third party css -->
    <link href="{{ asset('assets/css/vendor/dataTables.bootstrap5.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/vendor/responsive.bootstrap5.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/vendor/buttons.bootstrap5.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/vendor/select.bootstrap5.css') }}" rel="stylesheet" type="text/css">
    <!-- third party css end -->
@endpush

@section('content')
    <div class="container">

        @component('components.breadcrumb')
            @slot('title')
            @lang('result_entry.completed_mark')
            @endslot
            @slot('breadcrumb1')
                @lang('common.dashboard')
            @endslot
            @slot('breadcrumb1_link')
                {{ route('dashboard') }}
            @endslot
            @if (\App\Traits\RolePermissionTrait::checkRoleHasPermission('user', 'create'))
                @slot('action_button1')
                    @lang('common.add_new')
                @endslot
                @slot('action_button1_link')
                    {{ route('view_completed_subject.create') }}
                @endslot
            @endif
            @slot('action_button1_class')
                btn-primary
            @endslot
        @endcomponent

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="header-title">  @lang('result_entry.completed_mark')</h4>
                        <ul class="nav nav-tabs nav-bordered mb-3">
                            <li class="nav-item">
                                <a href="#users-tab-all" data-bs-toggle="tab" aria-expanded="false" class="nav-link active">
                                    @lang('common.all')
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="#users-tab-deleted" data-bs-toggle="tab" aria-expanded="true" class="nav-link">
                                    @lang('common.deleted_list')
                                </a>
                            </li>
                        </ul> <!-- end nav-->
                        <div class="tab-content">
                            <div class="tab-pane show active" id="users-tab-all">
                                <table id="datatable-users-all" class="table table-striped dt-responsive nowrap w-100">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>@lang('common.date')</th>
                                            <th>@lang('mpo_nationalization.subject')</th>
                                            <th>@lang('mpo_nationalization.layer')</th>
                                            <th>@lang('mpo_nationalization.memorial')</th>
                                          
                                            <th>@lang('common.image')</th>
                                            <th>@lang('common.action')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {{-- @if ($data)
                                        @foreach ($data as $v)
                                        <tr>
                                            <td>{{$i++}}</td>
                                            <td>{{$v->date}}</td>
                                            <td>
                                                @if($lang == 'en'){{ $v->subject ?: $v->subject_bn}}@else {{$v->subject_bn ?: $v->subject}}@endif
                                            </td> 
                                            <td>
                                                @if($lang == 'en'){{ $v->layer ?: $v->layer_bn}}@else {{$v->layer_bn ?: $v->layer}}@endif
                                            </td>  
                                            <td>
                                                {{$v->memorial_no}}
                                            </td> 
                                            <td><a href="{{asset('admin/mpo_nationalization')}}/{{$v->image}}" download="" class="btn btn-success btn-sm">@lang('common.download')</a></td> --}}
                                            {{-- <td>
                                                
                                                <img src="" alt="" style="height: 50px;width:50px;">
                                            </td> --}}
                                            {{-- <td>
                                                <a class="btn btn-sm btn-info" href="{{route('mpo_nationalization.edit',$v->id)}}"><i class="fa fa-edit"></i></a>
                                                <form method="post" action="{{route('mpo_nationalization.destroy',$v->id)}}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-sm btn-danger" type="submit"><i class="fa fa-trash"></i></button>
                                                </form>
                                            </td>
                                        </tr> --}}
                                        {{-- @endforeach
                                        @endif --}}
                                        
                                    </tbody>
                                </table>
                            </div> <!-- end all-->
                            {{-- @php
                            use App\Models\mpoNationalizatio;
                            $deleted = mpoNationalizatio::onlyTrashed()->get();
                            $i = 1;
                            @endphp
                            <div class="tab-pane" id="users-tab-deleted">
                                <table id="datatable-users-deleted" class="table table-striped dt-responsive nowrap w-100">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>@lang('common.date')</th>
                                            <th>@lang('mpo_nationalization.subject')</th>
                                            <th>@lang('mpo_nationalization.layer')</th>
                                            <th>@lang('mpo_nationalization.memorial')</th>
                                          
                                           
                                            <th>@lang('common.action')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if($deleted)
                                        @foreach ($deleted as $v)
                                        <tr>
                                            <td>{{$i++}}</td>
                                            <td>{{$v->date}}</td>
                                            <td>
                                                @if($lang == 'en'){{ $v->subject }}@else {{$v->subject_bn}}@endif
                                            </td> 
                                            <td>
                                                @if($lang == 'en'){{ $v->layer }}@else {{$v->layer_bn}}@endif
                                            </td>  
                                            <td>
                                                {{$v->memorial_no}}
                                            </td> 
                                            
                                            <td>
                                                <a href="{{ url('retrive_mpo') }}/{{ $v->id }}" class="btn btn-sm btn-warning">@lang('common.restore')</a>
                                                <a href="{{ url('delete_mpo') }}/{{ $v->id }}" class="btn btn-danger btn-sm">@lang('common.deleted_permanently')</a>
                                            </td>
                                        </tr>
                                        
                                        @endforeach
                                        @endif --}}
                                    </tbody>
                                </table>
                            </div> <!-- end deleted-->
                        </div> <!-- end tab-content-->

                    </div> <!-- end card body-->
                </div> <!-- end card -->
            </div><!-- end col-->
        </div>

    </div>
@endsection

@push('footer_scripts')
    <!-- third party js -->
    <script src="{{ asset('assets/js/vendor/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/dataTables.bootstrap5.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/responsive.bootstrap5.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/buttons.bootstrap5.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/buttons.flash.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/buttons.print.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/dataTables.keyTable.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/dataTables.select.min.js') }}"></script>
    <!-- third party js ends -->

    <!-- demo app -->
    <script src="{{ asset('assets/js/pages/demo.datatable-init.js') }}"></script>
    <!-- end demo js-->

    <script>
        $(function() {
            $('#datatable-users-all').DataTable();
        });
        $(function() {
            $('#datatable-users-deleted').DataTable();
        });
    </script>

    @include('components.delete_script')
@endpush
