@extends('layouts.master')
@section('content')

@push('header_styles')
<!-- third party css -->
<link href="{{ asset('assets/css/vendor/dataTables.bootstrap5.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/css/vendor/responsive.bootstrap5.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/css/vendor/buttons.bootstrap5.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/css/vendor/select.bootstrap5.css') }}" rel="stylesheet" type="text/css">
<!-- third party css end -->

@endpush


<link rel="stylesheet" type="text/css"
href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>




<div class="container mt-2">
		@component('components.breadcrumb')
            @slot('title')
                @lang('online_lecture_upload.viewtitle')
            @endslot
            @slot('breadcrumb1')
                @lang('common.dashboard')
            @endslot
            @slot('breadcrumb1_link')
                {{ route('dashboard') }}
            @endslot
            @if (\App\Traits\RolePermissionTrait::checkRoleHasPermission('role', 'create'))
                @slot('action_button1')
                    @lang('common.add_new')
                @endslot
                @slot('action_button1_link')
                    {{ route('online_lecture_upload.create') }}
                @endslot
            @endif
            @slot('action_button1_class')
                btn-primary
            @endslot
        @endcomponent
	<div class="col-12">

		<div class="card">
			<div class="card-body">

				<h3>@lang('online_lecture_upload.managetitle')</h3><br>

				<ul class="nav nav-tabs nav-bordered mb-3">
                            <li class="nav-item">
                                <a href="#users-tab-all" data-bs-toggle="tab" aria-expanded="false" class="nav-link active">
                                    @lang('common.all')
                                </a>
                            </li>
                        </ul> <!-- end nav-->
                        <div class="tab-content">
                            <div class="tab-pane show active" id="users-tab-all">
								@php
                                $sl=1;
                                @endphp
                                <table class="table table-striped dt-responsive nowrap w-100" id="alternative-page-datatable" >
                                    <thead>
                                        <tr>
											<th>#</th>
											<th>@lang('common.date')</th>
											<th>@lang('online_lecture_upload.class_name')</th>
											<th>@lang('online_lecture_upload.group_name')</th>
											<th>@lang('online_lecture_upload.title')</th>
											<th>@lang('online_lecture_upload.teacher_name')</th>
											<th>@lang('common.status')</th>
											<th>@lang('common.action')</th>
                                        </tr>
                                    </thead>
									<tbody>
										@if($data)
										@foreach($data as $d)
										<tr>
											<td>{{$sl++}}</td>
											<td>{{$d->date}}</td>
											<td>@if($lang == 'en'){{ $d->class_name ?: $d->class_name_bn}}@else {{$d->class_name_bn ?: $d->class_name}}@endif</td>
											<td>@if($lang == 'en'){{ $d->group_name ?: $d->group_name_bn}}@else {{$d->group_name_bn ?: $d->group_name}}@endif</td>
											<td>@if($lang == 'en'){{ $d->title_en ?: $d->title_bn}}@else {{$d->title_bn ?: $d->title_en}}@endif</td>
											<td>@if($lang == 'en'){{ $d->teacher_name_en ?: $d->teacher_name_bn}}@else {{$d->teacher_name_bn ?: $d->teacher_name_en}}@endif</td>
											<td>
												@if($d->status == 1)
												<span class="btn btn-success btn-sm">@lang('common.active')</span>
												@else
												<span class="btn btn-danger btn-sm">@lang('common.inactive')</span>
												@endif
											</td>
											<td>
												<div class="btn-group">
													<a href="{{route('online_lecture_upload.edit',$d->id)}}" class="btn btn-info border-0 edit text-light">@lang('common.edit')</a>
													<form action="{{route('online_lecture_upload.destroy',$d->id)}}" method="POST">
														@csrf
														@method('DELETE')
														<button type="submit" class="btn btn-danger" onClick="return confirm('Are You Sure?')">@lang('common.delete')</button>
													</form>
												</div>
											</td>
										</tr>
										@endforeach
										@endif
									</tbody>
                                </table>
                            </div> <!-- end all-->
                        </div> <!-- end tab-content-->
			</div> <!-- end card body-->
		</div> <!-- end card -->
	</div><!-- end col-->
</div>






@push('footer_scripts')
<!-- third party js -->
<script src="{{ asset('assets/js/vendor/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/js/vendor/dataTables.bootstrap5.js') }}"></script>
<script src="{{ asset('assets/js/vendor/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('assets/js/vendor/responsive.bootstrap5.min.js') }}"></script>
<script src="{{ asset('assets/js/vendor/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('assets/js/vendor/buttons.bootstrap5.min.js') }}"></script>
<script src="{{ asset('assets/js/vendor/buttons.html5.min.js') }}"></script>
<script src="{{ asset('assets/js/vendor/buttons.flash.min.js') }}"></script>
<script src="{{ asset('assets/js/vendor/buttons.print.min.js') }}"></script>
<script src="{{ asset('assets/js/vendor/dataTables.keyTable.min.js') }}"></script>
<script src="{{ asset('assets/js/vendor/dataTables.select.min.js') }}"></script>
<!-- third party js ends -->

<!-- demo app -->
<script src="{{ asset('assets/js/pages/demo.datatable-init.js') }}"></script>
<!-- end demo js-->


@endpush

<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>

<script>
	@if(Session::has('message'))
	toastr.options =
	{
		"closeButton" : true,
		"progressBar" : true
	}
	toastr.success("{{ session('message') }}");
	@endif

	@if(Session::has('error'))
	toastr.options =
	{
		"closeButton" : true,
		"progressBar" : true
	}
	toastr.error("{{ session('error') }}");
	@endif

	@if(Session::has('info'))
	toastr.options =
	{
		"closeButton" : true,
		"progressBar" : true
	}
	toastr.info("{{ session('info') }}");
	@endif

	@if(Session::has('warning'))
	toastr.options =
	{
		"closeButton" : true,
		"progressBar" : true
	}
	toastr.warning("{{ session('warning') }}");
	@endif
</script>





@endsection
