@extends('layouts.master')

@section('title') @lang('member.backups') @endsection

@push('header_styles')

@endpush 

@section('content')

    @component('components.breadcrumb')
        @slot('action_button2')
            @lang('common.back')
        @endslot
        @php
            $previous_url = url()->previous();
        @endphp
        @slot('action_button2_link')
            {{ url($previous_url) }}
        @endslot
        @slot('action_button2_class')
            btn-dark
        @endslot
    @endcomponent

    <h3>Database Backups</h3>
    <div class="row">
        <div class="col-xs-12 clearfix">
            <form action="{{ url('backup/create') }}" method="GET" class="add-new-backup CreateBackupForm" enctype="multipart/form-data">
                {{ csrf_field() }}
                <input type="submit" name="submit" class="theme-button btn btn-primary pull-left" style="margin-bottom:2em;" value="Create Database Backup">
            </form>

            <form action="{{ url('backup/clean') }}" method="GET" class="add-new-backup CleanBackupForm" enctype="multipart/form-data">
                {{ csrf_field() }}
                <input type="submit" name="submit" class="theme-button btn btn-info" style="margin-bottom:2em;" value="Clean Backups">
            </form>
        </div>
        <div class="col-xs-12">
            @if (count($backups))
                <table class="table table-striped table-bordered">
                    <thead>
                    <tr>
                        <th>File Name</th>
                        <th>File Size</th>
                        <th>Created Date</th>
                        <th>Created Age</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($backups as $backup)
                        <tr>
                            <td>{{ $backup['file_name'] }}</td>
                            <td>{{ \App\Http\Controllers\BackupController::humanFilesize($backup['file_size']) }}</td>
                            <td>
                                {{ date('F jS, Y, g:ia (T)',$backup['last_modified']) }}
                            </td>
                            <td>
                                {{ \Carbon\Carbon::parse($backup['last_modified'])->diffForHumans() }}
                            </td>
                            <td class="text-right">
                                <a class="btn btn-success" href="{{ url('backup/download/'.$backup['file_name']) }}"><i class="fa fa-cloud-download"></i> Download</a>
                                <a class="btn btn-danger" onclick="return confirm('Do you really want to delete this file')" data-button-type="delete" href="{{ url('backup/delete/'.$backup['file_name']) }}"><i class="fa fa-trash-o"></i> Delete</a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            @else
                <div class="well">
                    <h4>No backups</h4>
                </div>
            @endif
        </div>
    </div>


@endsection

@push('footer_scripts')

@endpush


