<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class PagesTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        

        \DB::table('pages')->delete();
        
        \DB::table('pages')->insert(array (
            0 => 
            array (
                'id' => 1,
                'title' => 'About Us',
                'title_bn' => 'আমাদের সম্পর্কে',
                'details' => 'ফেনী সরকারী কলেজ শিক্ষা মন্ত্রণালয়ের অধীনে মাধ্যমিক ও উচ্চ শিক্ষা অধিদপ্তরের প্রত্যক্ষ নিয়ন্ত্রণে উচ্চ মাধ্যমিক স্নাতক ও স্নাতকোত্তর পর্যায়ে পাঠদানকারী একটি সরকারী শিক্ষা প্রতিষ্ঠান।

দক্ষিণ- পূর্ব বাংলার অন্যতম প্রাচীন ও ঐতিহ্যবাহী শিক্ষা প্রতিষ্ঠান ফেনী সরকারী কলেজ প্রতিষ্ঠার গোড়াপত্তন হয় ১৯১৮ সালে খান বাহাদুর বজলুল হকের নেতৃত্বে একটি ট্রাস্ট বোর্ড গঠনের মাধ্যমে। কলেজের জম্ম- লগ্নে প্রথম গভর্ণিং বডির সদস্য ছিলেন মরহুম খান বাহাদুর আবদুল আজিজ, মরহুম খান সাহেব মৌলভী বজলুল হক, মরহুম মৌলভী আব্দুল খালেক, মরহুম মৌলভী হাছান আলী, মরহুম মৌলভী আবদুস সাত্তার, সর্বপ্রয়াত শ্রীরমণী মোহান গোস্বাামী, সর্বপ্রয়াত শ্রীগুরু দাস কর, শ্রীকালিজয় চক্রবতী প্রমুখ। কমিটির প্রথম সভাপতি ছিলেন ফেনীর তখনকার মহকুমা প্রশাসক জনাব আকরামুজ্জামান খান এবং প্রথম সেক্রেটারী ছিলেন মরহুম মৌলভী আব্দুল খালেক।
তাঁরা ফেনী হাই স্কুল ( বর্তমান ফেনী সরকারী পাইলট উচ্চ মাধ্যমিক বিদ্যালয়) কর্তৃপক্ষের থেকে বার্ষিক এক টাকা চার আনা খাজনায় বর্তমান মূল কলা ভবনের জায়গাটা পত্তন নিয়ে কলেজ নির্মাণের কাজ শুরু করেন। কলেজ প্রতিষ্ঠা লগ্নে কোলকাতা ও রেঙ্গুন প্রবাসী এ অঞ্চলের কর্মজীবী মানুষেরা কলেজ স্থাপনের জন্য উদারহস্তে বিপুল অর্থ সাহায্য করেছিলেন।
প্রাচ্যের অক্রফোর্ড খ্যাত ‘ঢাকা বিশ্ববিদ্যালয়’ ১৯২১ সালে প্রতিষ্ঠিত হওয়ার মাত্র এক বছর পর ১৯২২ সালে ‘ফেনী কলেজ’ প্রতিষ্ঠিত হয় এবং একই বছর ৮ আগস্ট বাংলা, ইংরেজি, আরবি, ফার্সি, সংস্কৃত, গণিত, ইতিহাস ও যুক্তিবিদ্যা বিষয়ে ১৪৬ জন শিক্ষার্থী নিয়ে আই এ ক্লাস চালু হয়। শুরু থেকেই উন্নয়নের লক্ষ্যে দৃঢ়নিষ্ঠ অগ্রগতি অর্জিত হওয়ায় সরকার ও বিশ্ববিদ্যালয় কর্তৃপক্ষ মাত্র দু’বছরের মধ্যেই ১৯২৪ সালে কলেজটিকে প্রথম শ্রেণির মর্যাদায় উন্নিত করে কলিকাতা বিশ্ববিদ্যালয়ের অধীনে আরবি ও ইতিহাস বিষয়ে অনার্সসহ ডিগ্রী পর্যায়ে বি.এ কোর্সে পাঠদান অনুমোদন করে । 
সারা জনপদ জুড়ে ব্যাপক গণ-সচেতনতা ছাড়িয়ে দিয়েছিলেন উদ্যোক্তারা। ফলে অনিতকালের মধ্যে প্রয় ২০,০০০/= টাকা অনুদান সংগৃহীত হয়। নোয়াখালী জেলা বোর্ড হিন্দু ও মুসলিম শিক্ষার্থীদের পৃথক ছাত্রাবাস স্থাপনের জন্য ৫০,০০০/- টাকা অনুদান প্রদান করে। ১৯২৬ সালের ১০ আগস্ট তদানিন্তন বৃটিশ ভারতের মহামান্য গভর্ণর স্যার হিউ ল্যন্সডাউন স্টিফেনশন কে সি আই, এস আই সি এস কলেজের মূল ভবনের দোতলা উদ্বোধন করেন। ফেনী কলেজ স্থাপনে শহরের হাজারী বাড়ি ও ছাগলনাইয়ার সাহা পরিবার জমি ও অর্থ প্রদান করে।

সারা ভূ-ভারত জুড়ে অসহযোগ আন্দোলন, খেলাফত ও স্বরাজ আন্দোলন এবং বিশ্বযুদ্বোত্তর অস্থিতিকর পরিস্থিতির মধ্যেও উদ্যোগক্তাগণ ফেনীতে একটি উচ্চ শিক্ষা পাদপীঠ স্থাপনের তাঁদের প্রচেষ্টায় ব্রত থেকে সাফল্য অর্জন করায় ১৯৩৭ সালের ‘ক্যালকাটা গ্যাজেট’ এ প্রকাশিত হয়েছিল. দ্বিতীয় বিশ্বযুদ্বের সময় ফেনী কলেজ ভক্ষন যুদ্বকালীন মিত্রবাহিনীর সামরিক হাসপাতাল হিসেবে ব্যবহৃত হওয়ায় কলেজের কাজকর্ম অস্থায়ীভিত্তিতে ব্রাক্ষণবাড়িয়াতে স্থানান্তরিত হয় এবং যুদ্ধ শেষে কলেজটি আবার স্ব- স্থানে ফিরে আসে।
কলেজটির ক্রমউন্নয়নের ধারায় ১৯৪১ সালে আই কম ও ১৯৪৭ সালে আই এস-সি কোর্স চালু হয়। ১৯৬২ সালে বি কম এবং ১৯৬৪ সালে বি.এস-সি কোর্স চালুর মধ্যে দিয়ে কলেজটি পূর্ণাঙ্গ ডিগ্রী কলেজে রূপান্তরিত হয়। ১৯৭৯ সালের ৭ মে জাতীয়করণ করা হলে ফেনী কলেজটি ফেনী সরকারী কলেজ নামে নব যাত্রা শুরু করে।
এ পর্যায়ে ১৯৯৭-১৯৯৮ শিক্ষা বর্ষে অনার্স এবং ২০১০-২০১১ শিক্ষা বর্ষে মাস্টার্স শেষ পর্বের কোর্স চালু হয়। বর্তমানে ফেনী সরকারী কলেজে মানবিক, বিজ্ঞান, বাণিজ্য ও সামাজিক বিজ্ঞান অনুষদের অধীনে উচ্চ মাধ্যমিক পর্যায়ে ১৬ টি বিষয়ে, স্নাতক (পাস) পর্যায়ে ১৫ বিষয়ে, অনার্স পর্যায়ে ১৫ টি বিষয়ে ( বাংলা, ইংরেজী, অর্থনীতি, রাষ্ট্রবিজ্ঞান, ইসলামের ইতিহাস ও সংস্কৃতি, ইতিহাস, দর্শন, সমাজকর্ম, হিসাববিজ্ঞান, ব্যবস্থাপনা, গণিত, পদার্থ বিজ্ঞান, রসায়ন, প্রাণিবিজ্ঞান ও উদ্ভিদ বিজ্ঞান) এবং মাস্টার্স শেষ পর্বে ৭ টি বিষয়ে ( বাংলা, অর্থনীতি, রাষ্ট্রবিজ্ঞান, সমাজকর্ম, হিসাববিজ্ঞান, ব্যবস্থাপনা ও গণিত) কোর্স চালু রয়েছে। অধ্যক্ষ, উপাধ্যক্ষসহ ১৫ বিভাগে মোট শিক্ষক সংখ্যা ৭২ জন। নৈসর্গিক সৌন্দর্যের এক অপার লীলাভূমি ফেনী সরকারী কলেজের মূল ক্যাম্পাস ১০.৫০ একর জমির ওপর অবস্থিত।
পুরাতন ঢাকা - চট্টগ্রাম মহা সড়কের পাশে ১৬.৬৬ একর জমি হুকুম দখল করা হয়। পরবর্তীতে প্রকল্পটি পরিত্যক্ত হয়। বর্তমানে উক্ত ১৬.৬৬ একর জমির মধ্যে ১০.০০ একর জমির উপর ফেনী আধুনিক হাসপাতাল স্থাপন করা হয়েছে। অবশিষ্ট জায়গার মধ্যে কিছু অংশে বি.এন. সি.সি ১নং ময়নামতি ব্যটালিয়ানের হেড কোয়ারটার, একটি অংশে ফেনী জেলা শিক্ষা অফিস এবং বাকী অংশে ফেনী সরকারী কলেজের ছাত্রাবাস নির্মান করা হয়েছে।

একাত্তরের মুক্তিযুদ্ধে ফেনী কলেজের শিক্ষক/শিক্ষার্থীদের ছিল গৌরবোজ্জল ভূমিকা। প্রাণিবিদ্যা বিভাগের অধ্যাপক ফজলুল হক. প্রাক্তন ভিপি মৌলান সৈয়দ ওয়ায়েজ উদ্দিন, বীরোত্তম মেজর সালাউদ্দিন মমতাজ, আবু তাহির প্রমুখ একাত্তরের মুক্তিযুদ্ধে শহীদ হন। বীর মুক্তিযোদ্ধা লেঃ কর্ণেল (অবঃ) জাফর ইমাম বীরবিক্রম, প্রাক্তন জি এস ও এমপি জয়নাল আবেদীন হাজারী, প্রাক্তন ভিপি ও এমপি অধ্যাপক জয়নাল আবেদিন, প্রাক্তন ভিপি জাফর উল্লাহ খান, কমান্ডার মর্তুজা, মোতালেব, কামাল, মোশারফ, কাজী নুরুন নবী, শাজাহন, মোঃ মুছা মিয়া, প্রাক্তন ডিসি আবু তাহের ভূইয়াঁ প্রমুখ ছিলেন ফেনী কলেজের ছাত্র।

একাত্তরের মুক্তিযুদ্ধের সময় কলেজটি হানাদার বাহিনীর ঘাঁটি গিমেকে ব্যবহৃত হওয়ায় আসবাবপত্র, বই- পুস্তক. বৈজ্ঞানিক যন্ত্রপাতি প্রায় সব কিছুই ধবংসপ্রাপ্ত হয়।
ফেনী কলেজ তার সুদীর্ঘ ইতিহাসে বিভিন্ন সময়ে বহু বিদগ্ধ ও কিংবদন্তী শিক্ষকের সেবা পাওয়ার সৌভাগ্য পেয়েছে। তাঁদের মধ্যে কয়েক জনঃ বাংলা সাহিত্যের প্রখ্যাত গবেষক গোপাল হালদার, ড. আহমদ শরীফ, ড. নজমুল করিম. ড. মোজাফফর আহমদ, ড. শামসুল হক, অধ্যাপক আসহাব উদ্দিন, প্রখ্যাত সাংবাদিক আবদুস সালাম, বাংলাদেশ পুলিশের প্রাক্তন আই জি ইমাজউদ্দিন, প্রাক্তন সচিব আবদুল আউয়াল, প্রাক্তন সচিব মহিউদ্দিন আহমদ প্রমুখ। এ কলেজের কৃতি ছাত্রদের মধ্যে অন্যতম হচ্ছেন- বাংলাদেশের প্রাক্তন প্রধানমন্ত্রী মিজানুর রহমান চৌধুরী, প্রাক্তন পররাষ্ট্রমন্ত্রী শামসুল হক, কেবিনেট মন্ত্রী লে: কর্ণেল (অব:) জাফর ইমাম বীর বিক্রম, প্রখ্যাত সাংবাদিক ওবায়দুল হক, প্রাক্তন ভিসি ছালেহ আহমেদ , প্রাক্তন ভিসি কামাল উদ্দিন, প্রাক্তন ভিসি ড. এ কে আজাদ চৌধুরী ও ড. আনোয়ার উল্লাহ চৌধুরী, হাই কোর্টের আপিল বিভাগের মাননীয় বিচারপতি কাজী ওবায়দুল হক প্রমুখ।',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            1 => 
            array (
                'id' => 2,
                'title' => 'Mission & Vission',
                'title_bn' => 'লক্ষ্য ও উদ্দেশ্য',
                'details' => 'ফেনী সরকারী কলেজ এর দৃষ্টি সামাজিক শৃঙ্খলা, সৌহার্দ্য, সঠিক শিক্ষা, সৃজনশীলতা, জ্ঞান, নৈতিকতা, দেশপ্রেম ও ধর্মীয় অর্থে উচ্চ মান জানার মাধ্যমে একবিংশ শতাব্দীর চ্যালেঞ্জ সাক্ষাৎ করতে সক্ষম একটি জাতি বিল্ড আপ করা। মিশন শিক্ষা একটি নতুন এলাকা পরিচয় বাস্তব মানুষের তৈরি কেন্দ্র হবে যে। একাডেমিক সমৃদ্ধির সাথে সাথে পুরো জীবনের জন্য মোট শিক্ষা প্রদান। তার দৃঢ় অঙ্গীকার সাধারণ এবং অর্থনৈতিকভাবে অনগ্রসর জন্য শিক্ষার আন্তর্জাতিক মান নিশ্চিত করার জন্য সব আধুনিক সুযোগ প্রদান করে ছাত্র। নৈতিক, ধর্মীয় ও সামাজিক মূল্যবোধের উচ্চ মান সঙ্গে একটি দেশপ্রেমী এবং বিশ্বপ্রেমিক জাতি নির্মাণ। নিজেদের দক্ষ করতে সক্ষম হবে যারা আলোকিত পৃথক উত্পাদন, ভাল শিক্ষিত, দক্ষ এবং সম্ভাব্য গতিশীলতা এবং বিশ শতকের চ্যালেঞ্জ মোকাবেলা করার জন্য যথেষ্ট।',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            2 => 
            array (
                'id' => 3,
                'title' => 'History',
                'title_bn' => 'ইতিহাস',
            'details' => '<p style="margin-bottom: 10px; color: rgb(51, 51, 51); text-align: justify; font-family: &quot;Times New Roman&quot;, Times, serif;"><span style="font-weight: 700;"><span style="color: rgb(79, 129, 189);">ফেনী সরকারী কলেজ শিক্ষা মন্ত্রণালয়ের অধীনে মাধ্যমিক ও উচ্চ শিক্ষা অধিদপ্তরের প্রত্যক্ষ নিয়ন্ত্রণে উচ্চ মাধ্যমিক স্নাতক ও স্নাতকোত্তর পর্যায়ে পাঠদানকারী একটি সরকারী শিক্ষা প্রতিষ্ঠান।</span></span></p><div>দক্ষিণ- পূর্ব বাংলার অন্যতম প্রাচীন ও ঐতিহ্যবাহী শিক্ষা প্রতিষ্ঠান ফেনী সরকারী কলেজ প্রতিষ্ঠার গোড়াপত্তন হয় ১৯১৮ সালে খান বাহাদুর বজলুল হকের নেতৃত্বে একটি ট্রাস্ট বোর্ড গঠনের মাধ্যমে। কলেজের জম্ম- লগ্নে প্রথম গভর্ণিং বডির সদস্য ছিলেন মরহুম খান বাহাদুর আবদুল আজিজ, মরহুম খান সাহেব মৌলভী বজলুল হক, মরহুম মৌলভী আব্দুল খালেক, মরহুম মৌলভী হাছান আলী, মরহুম মৌলভী আবদুস সাত্তার, সর্বপ্রয়াত শ্রীরমণী মোহান গোস্বাামী, সর্বপ্রয়াত শ্রীগুরু দাস কর, শ্রীকালিজয় চক্রবতী প্রমুখ। কমিটির প্রথম সভাপতি ছিলেন ফেনীর তখনকার মহকুমা প্রশাসক জনাব আকরামুজ্জামান খান এবং প্রথম সেক্রেটারী ছিলেন মরহুম মৌলভী আব্দুল খালেক।</div><div>&nbsp;তাঁরা ফেনী হাই স্কুল ( বর্তমান ফেনী সরকারী পাইলট উচ্চ মাধ্যমিক বিদ্যালয়) কর্তৃপক্ষের থেকে বার্ষিক এক টাকা চার আনা খাজনায় বর্তমান মূল কলা ভবনের জায়গাটা পত্তন নিয়ে কলেজ নির্মাণের কাজ শুরু করেন। কলেজ প্রতিষ্ঠা লগ্নে কোলকাতা ও রেঙ্গুন প্রবাসী এ অঞ্চলের কর্মজীবী মানুষেরা কলেজ স্থাপনের জন্য উদারহস্তে বিপুল অর্থ সাহায্য করেছিলেন।<br>প্রাচ্যের অক্রফোর্ড খ্যাত ‘ঢাকা বিশ্ববিদ্যালয়’ ১৯২১ সালে প্রতিষ্ঠিত হওয়ার মাত্র এক বছর পর ১৯২২ সালে ‘ফেনী কলেজ’ প্রতিষ্ঠিত হয় এবং একই বছর ৮ আগস্ট বাংলা, ইংরেজি, আরবি, ফার্সি, সংস্কৃত, গণিত, ইতিহাস ও যুক্তিবিদ্যা বিষয়ে ১৪৬ জন শিক্ষার্থী নিয়ে আই এ ক্লাস চালু হয়। শুরু থেকেই উন্নয়নের লক্ষ্যে দৃঢ়নিষ্ঠ অগ্রগতি অর্জিত হওয়ায় সরকার ও বিশ্ববিদ্যালয় কর্তৃপক্ষ মাত্র দু’বছরের মধ্যেই ১৯২৪ সালে কলেজটিকে প্রথম শ্রেণির মর্যাদায় উন্নিত করে কলিকাতা বিশ্ববিদ্যালয়ের অধীনে আরবি ও ইতিহাস বিষয়ে অনার্সসহ ডিগ্রী পর্যায়ে বি.এ কোর্সে পাঠদান অনুমোদন করে ।&nbsp;</div><div>সারা জনপদ জুড়ে ব্যাপক গণ-সচেতনতা ছাড়িয়ে দিয়েছিলেন উদ্যোক্তারা। ফলে অনিতকালের মধ্যে প্রয় ২০,০০০/= টাকা অনুদান সংগৃহীত হয়। নোয়াখালী জেলা বোর্ড হিন্দু ও মুসলিম শিক্ষার্থীদের পৃথক ছাত্রাবাস স্থাপনের জন্য ৫০,০০০/- টাকা অনুদান প্রদান করে। ১৯২৬ সালের ১০ আগস্ট তদানিন্তন বৃটিশ ভারতের মহামান্য গভর্ণর স্যার হিউ ল্যন্সডাউন স্টিফেনশন কে সি আই, এস আই সি এস কলেজের মূল ভবনের দোতলা উদ্বোধন করেন। ফেনী কলেজ স্থাপনে শহরের হাজারী বাড়ি ও ছাগলনাইয়ার সাহা পরিবার জমি ও অর্থ প্রদান করে।<br><br>সারা ভূ-ভারত জুড়ে অসহযোগ আন্দোলন, খেলাফত ও স্বরাজ আন্দোলন এবং বিশ্বযুদ্বোত্তর অস্থিতিকর পরিস্থিতির মধ্যেও উদ্যোগক্তাগণ ফেনীতে একটি উচ্চ শিক্ষা পাদপীঠ স্থাপনের তাঁদের প্রচেষ্টায় ব্রত থেকে সাফল্য অর্জন করায় ১৯৩৭ সালের ‘ক্যালকাটা গ্যাজেট’ এ প্রকাশিত হয়েছিল. দ্বিতীয় বিশ্বযুদ্বের সময় ফেনী কলেজ ভক্ষন যুদ্বকালীন মিত্রবাহিনীর সামরিক হাসপাতাল হিসেবে ব্যবহৃত হওয়ায় কলেজের কাজকর্ম অস্থায়ীভিত্তিতে ব্রাক্ষণবাড়িয়াতে স্থানান্তরিত হয় এবং যুদ্ধ শেষে কলেজটি আবার স্ব- স্থানে ফিরে আসে।</div><div>&nbsp;কলেজটির ক্রমউন্নয়নের ধারায় ১৯৪১ সালে আই কম ও ১৯৪৭ সালে আই এস-সি কোর্স চালু হয়। ১৯৬২ সালে বি কম এবং ১৯৬৪ সালে বি.এস-সি কোর্স চালুর মধ্যে দিয়ে কলেজটি পূর্ণাঙ্গ ডিগ্রী কলেজে রূপান্তরিত হয়। ১৯৭৯ সালের ৭ মে জাতীয়করণ করা হলে ফেনী কলেজটি ফেনী সরকারী কলেজ নামে নব যাত্রা শুরু করে।</div><div>&nbsp;এ পর্যায়ে ১৯৯৭-১৯৯৮ শিক্ষা বর্ষে অনার্স এবং ২০১০-২০১১ শিক্ষা বর্ষে মাস্টার্স শেষ পর্বের কোর্স চালু হয়। বর্তমানে ফেনী সরকারী কলেজে মানবিক, বিজ্ঞান, বাণিজ্য ও সামাজিক বিজ্ঞান অনুষদের অধীনে উচ্চ মাধ্যমিক পর্যায়ে ১৬ টি বিষয়ে, স্নাতক (পাস) পর্যায়ে ১৫ বিষয়ে, অনার্স পর্যায়ে ১৫ টি বিষয়ে ( বাংলা, ইংরেজী, অর্থনীতি, রাষ্ট্রবিজ্ঞান, ইসলামের ইতিহাস ও সংস্কৃতি, ইতিহাস, দর্শন, সমাজকর্ম, হিসাববিজ্ঞান, ব্যবস্থাপনা, গণিত, পদার্থ বিজ্ঞান, রসায়ন, প্রাণিবিজ্ঞান ও উদ্ভিদ বিজ্ঞান) এবং মাস্টার্স শেষ পর্বে ৭ টি বিষয়ে ( বাংলা, অর্থনীতি, রাষ্ট্রবিজ্ঞান, সমাজকর্ম, হিসাববিজ্ঞান, ব্যবস্থাপনা ও গণিত) কোর্স চালু রয়েছে। অধ্যক্ষ, উপাধ্যক্ষসহ ১৫ বিভাগে মোট শিক্ষক সংখ্যা ৭২ জন। নৈসর্গিক সৌন্দর্যের এক অপার লীলাভূমি ফেনী সরকারী কলেজের মূল ক্যাম্পাস ১০.৫০ একর জমির ওপর অবস্থিত।</div><div>&nbsp;পুরাতন ঢাকা - চট্টগ্রাম মহা সড়কের পাশে ১৬.৬৬ একর জমি হুকুম দখল করা হয়। পরবর্তীতে প্রকল্পটি পরিত্যক্ত হয়। বর্তমানে উক্ত ১৬.৬৬ একর জমির মধ্যে ১০.০০ একর জমির উপর ফেনী আধুনিক হাসপাতাল স্থাপন করা হয়েছে। অবশিষ্ট জায়গার মধ্যে কিছু অংশে বি.এন. সি.সি ১নং ময়নামতি ব্যটালিয়ানের হেড কোয়ারটার, একটি অংশে ফেনী জেলা শিক্ষা অফিস এবং বাকী অংশে ফেনী সরকারী কলেজের ছাত্রাবাস নির্মান করা হয়েছে।<br><br>একাত্তরের মুক্তিযুদ্ধে ফেনী কলেজের শিক্ষক/শিক্ষার্থীদের ছিল গৌরবোজ্জল ভূমিকা। প্রাণিবিদ্যা বিভাগের অধ্যাপক ফজলুল হক. প্রাক্তন ভিপি মৌলান সৈয়দ ওয়ায়েজ উদ্দিন, বীরোত্তম মেজর সালাউদ্দিন মমতাজ, আবু তাহির প্রমুখ একাত্তরের মুক্তিযুদ্ধে শহীদ হন। বীর মুক্তিযোদ্ধা লেঃ কর্ণেল (অবঃ) জাফর ইমাম বীরবিক্রম, প্রাক্তন জি এস ও এমপি জয়নাল আবেদীন হাজারী, প্রাক্তন ভিপি ও এমপি অধ্যাপক জয়নাল আবেদিন, প্রাক্তন ভিপি জাফর উল্লাহ খান, কমান্ডার মর্তুজা, মোতালেব, কামাল, মোশারফ, কাজী নুরুন নবী, শাজাহন, মোঃ মুছা মিয়া, প্রাক্তন ডিসি আবু তাহের ভূইয়াঁ প্রমুখ ছিলেন ফেনী কলেজের ছাত্র।<br><br>একাত্তরের মুক্তিযুদ্ধের সময় কলেজটি হানাদার বাহিনীর ঘাঁটি গিমেকে ব্যবহৃত হওয়ায় আসবাবপত্র, বই- পুস্তক. বৈজ্ঞানিক যন্ত্রপাতি প্রায় সব কিছুই ধবংসপ্রাপ্ত হয়।</div><div>&nbsp;ফেনী কলেজ তার সুদীর্ঘ ইতিহাসে বিভিন্ন সময়ে বহু বিদগ্ধ ও কিংবদন্তী শিক্ষকের সেবা পাওয়ার সৌভাগ্য পেয়েছে। তাঁদের মধ্যে কয়েক জনঃ বাংলা সাহিত্যের প্রখ্যাত গবেষক গোপাল হালদার, ড. আহমদ শরীফ, ড. নজমুল করিম. ড. মোজাফফর আহমদ, ড. শামসুল হক, অধ্যাপক আসহাব উদ্দিন, প্রখ্যাত সাংবাদিক আবদুস সালাম, বাংলাদেশ পুলিশের প্রাক্তন আই জি ইমাজউদ্দিন, প্রাক্তন সচিব আবদুল আউয়াল, প্রাক্তন সচিব মহিউদ্দিন আহমদ প্রমুখ। এ কলেজের কৃতি ছাত্রদের মধ্যে অন্যতম হচ্ছেন- বাংলাদেশের প্রাক্তন প্রধানমন্ত্রী মিজানুর রহমান চৌধুরী, প্রাক্তন পররাষ্ট্রমন্ত্রী শামসুল হক, কেবিনেট মন্ত্রী লে: কর্ণেল (অব:) জাফর ইমাম বীর বিক্রম, প্রখ্যাত সাংবাদিক ওবায়দুল হক, প্রাক্তন ভিসি ছালেহ আহমেদ , প্রাক্তন ভিসি কামাল উদ্দিন, প্রাক্তন ভিসি ড. এ কে আজাদ চৌধুরী ও ড. আনোয়ার উল্লাহ চৌধুরী, হাই কোর্টের আপিল বিভাগের মাননীয় বিচারপতি কাজী ওবায়দুল হক প্রমুখ।</div>',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            3 => 
            array (
                'id' => 4,
                'title' => 'Citizen Charter',
                'title_bn' => 'সিটিজেন চার্টার',
                'details' => 'সিটিজেন চার্টার',
                'details_bn' => NULL,
                'image' => 'pages_image/3542.jpg',
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            4 => 
            array (
                'id' => 5,
                'title' => 'Student Information',
                'title_bn' => 'ছাত্র - ছাত্রী তথ্য চার্ট',
                'details' => 'ছাত্র - ছাত্রী তথ্য চার্ট',
                'details_bn' => NULL,
                'image' => 'pages_image/4447.pdf',
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            5 => 
            array (
                'id' => 6,
                'title' => 'Infrastructure',
                'title_bn' => 'ভৌত অবকাঠামো',
            'details' => '<p style=""><span style="color: rgb(0, 0, 0);">পরিকাঠামোর পরিপ্রেক্ষিতে, আইএমজিসি আন্তর্জাতিক মানের সাথে মেলে দেশের সেরা কলেজগুলির মধ্যে একটি। এটি বাংলাদেশের কয়েকটি বিখ্যাত কলেজের মধ্যে একটি যা আধুনিক সরঞ্জাম এবং কৌশলগুলির মাধ্যমে পাঠদানের সুবিধার্থে তার শ্রেণীকক্ষগুলিকে আপগ্রেড করেছে। কলেজে ওয়াই-ফাই সক্ষম এলসিডি প্রজেক্টর সহ কেন্দ্রীয় শীতাতপ নিয়ন্ত্রিত শ্রেণীকক্ষ, টিউটোরিয়াল কক্ষ, লাইব্রেরি, একটি অত্যাধুনিক সেমিনার কক্ষ এবং 750 জনের বেশি লোকের বসার ক্ষমতা সহ একটি সম্পূর্ণ সজ্জিত অডিটোরিয়াম রয়েছে। কলেজটি বিল্ডিংয়ে নতুন র‌্যাম্প, লিফট এবং বিশেষ শৌচাগার যুক্ত করে একটি ভিন্নভাবে সক্ষম বন্ধুত্বপূর্ণ ক্যাম্পাস হিসেবে গর্বিত। এছাড়াও, কলেজে বিভিন্ন ছাত্রদের পঠন, শ্রবণ এবং বোঝার প্রয়োজনীয়তাগুলি সমাধান করার জন্য বিভিন্ন সুবিধা রয়েছে। আইএমজিসি লাইব্রেরি হল একটি ক্ষমতায়নকারী ইউনিট যার একটি রিসোর্স সেন্টার ফর ভিজ্যুয়াললি চ্যালেঞ্জড যা স্ব-বাস্তবকরণের প্রক্রিয়ায় সহায়তা করার জন্য অডিও-ভিজ্যুয়াল এইডের একটি অ্যারের অধিকারী। কলেজটি সংস্কার করা হোস্টেল, চিকিৎসা সহায়তা ব্যবস্থা আন্তর্জাতিক মানের খেলার মাঠ দিয়ে সমৃদ্ধ। একটি সম্পূর্ণ ধোঁয়া ও যানবাহন মুক্ত অঞ্চল, কলেজটি সৌর গরম, রেইন ওয়াটার হার্ভেস্টিং, পেপার রিসাইক্লিং এবং অন্যান্য সবুজ উদ্যোগের সর্বশেষ উদ্যোগের সাথে তার শিক্ষার্থীদের একটি পরিবেশ বান্ধব পরিবেশ প্রদান করে। কলেজ সতর্কতা এবং নিরাপত্তার প্রয়োজনীয়তা মোকাবেলা করার জন্য ব্যবস্থা নিয়েছে। ক্যাম্পাসটি সিসিটিভি-সক্ষম একটি সুসজ্জিত এবং সুসজ্জিত ক্যাম্পাসের নিরাপত্তার প্রয়োজনীয়তা পূরণ করতে যেখানে প্রচুর লোক সমাগম হয়।</span></p>',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            6 => 
            array (
                'id' => 7,
                'title' => 'Yearly Work Plan',
                'title_bn' => 'বার্ষিক কর্ম পরিকল্পনা',
                'details' => 'বার্ষিক কর্ম পরিকল্পনা',
                'details_bn' => NULL,
                'image' => 'pages_image/9957.pdf',
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            7 => 
            array (
                'id' => 8,
                'title' => 'Communication',
                'title_bn' => 'যোগাযোগের ঠিকানা',
                'details' => 'ফেনী সরকারি কলেজ।
ফেনী রোড, ফেনী 3900, বাংলাদেশ।

ফোন নং: 033174049/01819323717
ই-মেইল: fenigovcollege@yahoo.com',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            8 => 
            array (
                'id' => 9,
                'title' => 'Rules & Regulation',
                'title_bn' => 'আচরণ বিধি',
                'details' => '1. ছাত্রছাত্রীরা ঝরঝরে, পরিষ্কার এবং সাধারণ পোশাকে কলেজে আসবে বলে আশা করা হচ্ছে। তাদের অবশ্যই প্রতিষ্ঠানগুলির দ্বারা রক্ষিত শালীনতার উচ্চ মানগুলির সাথে সঙ্গতিপূর্ণ হতে হবে। তারা আড়ম্বরপূর্ণ পোষাক পরা উচিত নয়.
2. সমস্ত পুরুষ ছাত্রদের প্যান্ট এবং শার্ট-বুশ শার্ট বা স্ল্যাক শার্ট পরা আশা করা হচ্ছে। টিশার্ট অনুমোদিত নয়। মহিলা ছাত্রদের কঠোরভাবে স্কার্ট, লেগিংস, জিন্স, ফ্রক এবং হাই টপ পরার অনুমতি নেই।
3. ছাত্রদের কলেজ বা নিজেদের অসম্মান আনা উচিত নয়. কলেজের অভ্যন্তরে বা বাহিরে যে কোন ধরনের অমানবিক ও অভদ্র আচরণের বিরুদ্ধে কঠোর ব্যবস্থা নেওয়া হবে।

4. ছাত্রদের ক্লাসে যোগদান এবং কলেজের সাথে সম্পর্কিত সমস্ত কার্যক্রমে নিয়মিত এবং সময়নিষ্ঠ হতে হবে। অধ্যক্ষের অনুমতি ব্যতীত ক্লাস চলাকালীন কোন শিক্ষার্থীকে শ্রেণীকক্ষে প্রবেশ বা ক্লাস রুম থেকে বের হতে দেওয়া হয় না। মধ্যাহ্নভোজের বিরতিতে তাদের বাইরে যাওয়ার অনুমতি নেই।

5. ছাত্রদের উচিত দাঁড়ানো এবং শিক্ষককে শুভেচ্ছা জানাতে হবে যখন তিনি ক্লাসে প্রবেশ করবেন। শিক্ষক তার আসন গ্রহণ করার পরে বা শিক্ষার্থীদের এটি করার নির্দেশ দেওয়ার পরেই তাদের আসন গ্রহণ করা উচিত।

6. তাদের বিভাগ নির্বিশেষে সকল শিক্ষককে শুভেচ্ছা জানাতে হবে।

7. ক্লাস চলাকালীন ক্লাসরুম, লাইব্রেরি, ল্যাবরেটরি, পরীক্ষার হল এবং কলেজ প্রাঙ্গণে কঠোর নীরবতা বজায় রাখতে হবে।

8. কলেজ ক্যাম্পাসে অধ্যক্ষ কর্তৃক অনুমোদিত নয় এমন বই, ম্যাগাজিন এবং অন্যান্য উপকরণ ব্যবহার করার অনুমতি দেওয়া হবে না।

9. সমস্ত হারানো সম্পত্তি কলেজ অফিসে আনতে হবে।

10. শিক্ষার্থীরা কলেজের সম্পত্তির যত্ন নেবে এবং প্রাঙ্গণকে পরিষ্কার-পরিচ্ছন্ন রাখতে সাহায্য করবে বলে আশা করা হচ্ছে। দেয়াল, দরজা বিকৃত করা বা আসবাবপত্র ভাঙ্গা শৃঙ্খলা ভঙ্গ এবং সহ্য করা হবে না।

11. অধ্যক্ষের অনুমতি ব্যতীত ছাত্রদের কলেজ প্রাঙ্গণে কোনো সভা আয়োজন করা বা কোনো উদ্দেশ্যে অর্থ সংগ্রহ করা নিষিদ্ধ।

12. ছাত্রদের কর্মঘণ্টা চলাকালীন কলেজে দর্শকদের আপ্যায়ন করার অনুমতি নেই। তাদের ব্যক্তিগত ফোন কল বা চিঠি গ্রহণ থেকে কঠোরভাবে নিষেধ করা হয়েছে।

13. শিক্ষার্থীর অনুমতি ছাড়া অফিস কক্ষ, স্টাফ রুম বা কম্পিউটার ল্যাবে প্রবেশ করা উচিত নয়।

14. মাসিক পরীক্ষা এবং মডেল পরীক্ষা পাঠ্যক্রমের অংশ এবং ছাত্রদের এই পরীক্ষাগুলো গ্রহণে আন্তরিক হতে হবে। পরীক্ষা বা পরীক্ষার সময় তাদের কোনো ধরনের অপকর্মে লিপ্ত হওয়া উচিত নয়।

15. ইভ-টিজিং কঠোরভাবে নিষিদ্ধ এবং ইভ-টিজারদের কলেজ থেকে বরখাস্ত করা হবে। 1998 সালের তামিলনাড়ু ইভ-টিজিং অধ্যাদেশ অনুসারে যে কেউ ইভ-টিজিং করে বা অংশগ্রহণ করে বা ইভ-টিজিং করে, কোনো শিক্ষাপ্রতিষ্ঠানের ভিতরে বা প্রাঙ্গনে, তার কারাদণ্ডের জন্য দায়ী যা এক বছর পর্যন্ত বাড়তে পারে বা আমরা কি জরিমানা করতে বাধ্য RS.10000/- বা উভয় পর্যন্ত প্রসারিত হতে পারে।',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            9 => 
            array (
                'id' => 10,
                'title' => 'Uniform',
                'title_bn' => 'ইউনিফর্ম',
                'details' => 'ইউনিফর্ম',
                'details_bn' => NULL,
                'image' => 'pages_image/1776.jpg',
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            10 => 
            array (
                'id' => 11,
                'title' => 'Fees Information',
                'title_bn' => 'ফিস সংক্রান্ত তথ্য',
                'details' => 'ফিস সংক্রান্ত তথ্য',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            11 => 
            array (
                'id' => 12,
                'title' => 'Exam Rules',
                'title_bn' => 'পরীক্ষার নিয়মাবলী',
                'details' => 'পরীক্ষার নিয়মাবলী',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            12 => 
            array (
                'id' => 13,
                'title' => 'Sports',
                'title_bn' => 'খেলাধুলা',
                'details' => 'খেলাধুলা',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            13 => 
            array (
                'id' => 14,
                'title' => 'Cultural Activites',
                'title_bn' => 'সাংস্কৃতিক কার্যক্রম',
                'details' => '<iframe width="750" height="315" src="https://www.youtube.com/embed/IJ8qN7qRpfw?si=gxorumhNk_R8xfmX" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            14 => 
            array (
                'id' => 15,
                'title' => 'Scouts',
                'title_bn' => 'স্কাউটস',
                'details' => 'স্কাউটস',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            15 => 
            array (
                'id' => 16,
                'title' => 'Girls Guide',
                'title_bn' => 'গার্লস গাইড',
                'details' => 'গার্লস গাইড',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            16 => 
            array (
                'id' => 17,
                'title' => 'BNCC',
                'title_bn' => 'বিএনসিসি',
                'details' => 'বিএনসিসি',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            17 => 
            array (
                'id' => 18,
                'title' => 'Red Crescent',
                'title_bn' => 'রেড ক্রিসেন্ট',
                'details' => 'রেড ক্রিসেন্ট',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            18 => 
            array (
                'id' => 19,
                'title' => 'Student Cabinet',
                'title_bn' => 'ছাত্র - ছাত্রী ক্যবিনেট',
                'details' => 'ছাত্র - ছাত্রী ক্যবিনেট',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            19 => 
            array (
                'id' => 20,
                'title' => 'Debate',
                'title_bn' => 'বিতর্ক প্রতিযোগীতা',
                'details' => 'বিতর্ক প্রতিযোগীতা',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            20 => 
            array (
                'id' => 21,
                'title' => 'Language Club',
                'title_bn' => 'ল্যাঙ্গুয়েজ ক্লাব',
                'details' => 'ল্যাঙ্গুয়েজ ক্লাব',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            21 => 
            array (
                'id' => 22,
                'title' => 'Study Tour',
                'title_bn' => 'শিক্ষা সফর',
                'details' => 'শিক্ষা সফর',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            22 => 
            array (
                'id' => 23,
                'title' => 'Science Fair',
                'title_bn' => 'বিজ্ঞান মেলা',
                'details' => 'বিজ্ঞান মেলা',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            23 => 
            array (
                'id' => 24,
                'title' => 'Computer Club',
                'title_bn' => 'কম্পিউটার ক্লাব',
                'details' => 'কম্পিউটার ক্লাব',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            24 => 
            array (
                'id' => 25,
                'title' => 'Teachers Guideline',
                'title_bn' => 'গাইডলাইন শিক্ষক - কর্মচারী',
                'details' => 'গাইডলাইন শিক্ষক - কর্মচারী',
                'details_bn' => NULL,
                'image' => 'pages_image/90812.pdf',
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            25 => 
            array (
                'id' => 26,
                'title' => 'Library Information',
                'title_bn' => 'পাঠাগার তথ্য',
                'details' => 'পাঠাগার তথ্য',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
            26 => 
            array (
                'id' => 27,
                'title' => 'Hostel Information',
                'title_bn' => 'ছাত্রাবাস তথ্য',
                'details' => 'ছাত্রাবাস তথ্য',
                'details_bn' => NULL,
                'image' => NULL,
                'created_at' => NULL,
                'updated_at' => NULL,
            ),
        ));
        
        
    }
}