<?php $__env->startSection('content'); ?>
    <div class="container mt-2">
        <?php $__env->startComponent('components.breadcrumb'); ?>
            <?php $__env->slot('breadcrumb1'); ?>
                <?php echo app('translator')->get('common.dashboard'); ?>
            <?php $__env->endSlot(); ?>
        <?php echo $__env->renderComponent(); ?>
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <b><?php echo app('translator')->get('frontend.marks_entry'); ?></b>
                </div>
                <div class="card-body">
                    <form id="marksEntryForm" onsubmit="return false;">
                        <?php echo csrf_field(); ?>
                        <div class="table-responsive">
                            <table class="table">
                                <tr>
                                    <td><?php echo app('translator')->get('common.class'); ?><span class="text-danger">*</span></td>
                                    <td>
                                        <select name="class_id" id="class_id" class="form-control form-control-sm" onchange="getExamType();getGroup()">
                                            <option value=""><?php echo app('translator')->get('common.select_one'); ?></option>
                                            <?php if(isset($class)): ?>
                                            <?php $__currentLoopData = $class; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($c->id); ?>"><?php echo e($c->class_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                    </td>
                                    <td><?php echo app('translator')->get('common.exam_id'); ?><span class="text-danger">*</span></td>
                                    <td>
                                        <select name="exam_id" id="exam_id" class="form-control form-control-sm">
                                            <option value=""><?php echo app('translator')->get('common.select_one'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php echo app('translator')->get('common.group'); ?><span class="text-danger">*</span></td>
                                    <td>
                                        <select name="group_id" id="group_id" class="form-control form-control-sm">
                                            <option value=""><?php echo app('translator')->get('common.select_one'); ?></option>
                                        </select>
                                    </td>
                                    <td><?php echo app('translator')->get('common.subject_type'); ?><span class="text-danger">*</span></td>
                                    <td>
                                        <select name="subject_type" id="subject_type" class="form-control form-control-sm" onchange="getSubject()">
                                            <option value=""><?php echo app('translator')->get('common.select_one'); ?></option>
                                            <option value="CompulsorySubject">CompulsorySubject</option>
                                            <option value="GroupSubject">GroupSubject</option>
                                            <option value="OptionalSubject">OptionalSubject</option>
                                        </select>
                                    </td>

                                </tr>
                                <tr>
                                    <td><?php echo app('translator')->get('common.subject_id'); ?><span class="text-danger">*</span></td>
                                    <td>
                                        <select name="subject_id" id="subject_id" class="form-control form-control-sm" onchange="getSubjectPart()">
                                            <option value=""><?php echo app('translator')->get('common.select_one'); ?></option>
                                        </select>
                                    </td>
                                    <td><?php echo app('translator')->get('common.subject_part_id'); ?><span class="text-danger">*</span></td>
                                    <td>
                                        <select name="subject_part_id" id="subject_part_id"
                                            class="form-control form-control-sm">
                                            <option value=""><?php echo app('translator')->get('common.select_one'); ?></option>
                                        </select>
                                    </td>

                                </tr>
                                <tr>
                                    <td><?php echo app('translator')->get('common.file'); ?><span class="text-danger">*</span></td>
                                    <td colspan="3">
                                        <input type="file" name="excel" id="excel"
                                            class="form-control form-control-sm">
                                    </td>
                                </tr>
                                <tr>

                                    <td colspan="4" class="text-center">
                                        <button class="btn btn-sm btn-info" type="submit"><?php echo app('translator')->get('common.submit'); ?></button>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </form>
                </div>
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer_scripts'); ?>
<script>
    function getExamType() {
        var class_id = $('#class_id').val();
        $.ajax({
            url: "<?php echo e(route('getExamType')); ?>",
            type: "GET",
            data: {
                class_id: class_id
            },
            success: function(data) {
                $('#exam_id').html(data);
            }
        });
    }

    function getGroup() {
        var class_id = $('#class_id').val();
        $.ajax({
            url: "<?php echo e(route('getGroup')); ?>",
            type: "GET",
            data: {
                class_id: class_id
            },
            success: function(data) {
                $('#group_id').html(data);
            }
        });
    }

    function getSubject () {
        var subject_type = $('#subject_type').val();
        var class_id = $('#class_id').val();
        var group_id = $('#group_id').val();
        $.ajax({
            url: "<?php echo e(route('getSubject')); ?>",
            type: "GET",
            data: {
                subject_type: subject_type,
                class_id: class_id,
                group_id: group_id,
            },
            success: function(data) {
                $('#subject_id').html(data);
            }
        });
    }

    function getSubjectPart () {
        var subject_id = $('#subject_id').val();
        var exam_id = $('#exam_id').val();
        var class_id = $('#class_id').val();
        var group_id = $('#group_id').val();
        $.ajax({
            url: "<?php echo e(route('getSubjectPart')); ?>",
            type: "GET",
            data: {
                subject_id: subject_id,
                exam_id: exam_id,
                class_id: class_id,
                group_id: group_id,
            },
            success: function(data) {
                $('#subject_part_id').html(data);
            }
        });
    }

    $(document).ready(function () {
    console.log("jQuery is working!"); // Check if jQuery is loaded

    $("#marksEntryForm").on("submit", function (e) {
        e.preventDefault(); // Prevent default form submission
        e.stopPropagation(); // Stop duplicate event handling

        // Debugging: Check if preventDefault is actually working
        console.log("Form submission prevented");

        // Remove validation error classes
        $('.is-invalid').removeClass('is-invalid');
        $('.invalid-feedback').remove();

        var formData = new FormData(this);

        $.ajax({
            url: "<?php echo e(route('marks_entry.store')); ?>",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            beforeSend: function() {
                console.log("AJAX request is being sent...");
            },
            success: function (response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: response.message
                    });

                    $('#marksEntryForm')[0].reset();
                }
            },
            error: function (xhr) {
                if (xhr.status === 422) {
                    var errors = xhr.responseJSON.errors;
                    $.each(errors, function (key, value) {
                        $('#' + key).addClass('is-invalid');
                        $('#' + key).after('<div class="invalid-feedback">' + value[0] + '</div>');
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Something went wrong! Please try again.'
                    });
                }
            }
        });

        return false;
    });
});

</script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gzmcfenigov/public_html/resources/views/admin/marks_entry/index.blade.php ENDPATH**/ ?>