<div class="row mb-3">
    <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 my-2">
        <?php /** @var string $errors */ $error_class = $errors->has('parent_id') ? 'parsley-error ' : ''; ?>
        <label for="parent_id" class="form-label font-weight-bold"><?php echo app('translator')->get('menu.label_parent_id'); ?></label>
        <div class="form-group">
            <?php echo e(Form::select('parent_id', $menus, null, ['class' => $error_class . 'form-control select2', 'id' => 'parent_id', 'placeholder' => trans('menu.label_select_parent_id')])); ?>

            <?php if($errors->has('parent_id')): ?>
            <p class="text-danger"><?php echo e($errors->first('parent_id')); ?></p>
            <?php endif; ?>
        </div>
    </div>

    <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 my-2">
        <?php /** @var string $errors */ $error_class = $errors->has('name') ? 'parsley-error ' : ''; ?>
        <label for="name" class="form-label font-weight-bold"><?php echo app('translator')->get('menu.label_name'); ?></label>
        <sup class="text-danger">*</sup>
        <div class="form-group">
            <?php echo e(Form::text('name', null, ['class' => $error_class . 'form-control', 'id' => 'name', 'required' => 1])); ?>

            <?php if($errors->has('name')): ?>
            <p class="text-danger"><?php echo e($errors->first('name')); ?></p>
            <?php endif; ?>
        </div>
    </div>

    <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 my-2">
        <?php /** @var string $errors */ $error_class = $errors->has('bn_name') ? 'parsley-error ' : ''; ?>
        <label for="bn_name" class="form-label font-weight-bold"><?php echo app('translator')->get('menu.label_bn_name'); ?></label>
        <sup class="text-danger">*</sup>
        <div class="form-group">
            <?php echo e(Form::text('bn_name', null, ['class' => $error_class . 'form-control', 'id' => 'bn_name', 'required' => 1])); ?>

            <?php if($errors->has('bn_name')): ?>
            <p class="text-danger"><?php echo e($errors->first('bn_name')); ?></p>
            <?php endif; ?>
        </div>
    </div>

    <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 my-2">
        <?php /** @var string $errors */ $error_class = $errors->has('system_name') ? 'parsley-error ' : ''; ?>
        <label for="system_name" class="form-label font-weight-bold"><?php echo app('translator')->get('menu.label_system_name'); ?></label>
        <sup class="text-danger">*</sup>
        <div class="form-group">
            <?php echo e(Form::text('system_name', null, ['class' => $error_class . 'form-control', 'id' => 'system_name', 'required' => 1])); ?>

            <?php if($errors->has('system_name')): ?>
            <p class="text-danger"><?php echo e($errors->first('system_name')); ?></p>
            <?php endif; ?>
        </div>
    </div>

    <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 my-2">
        <?php /** @var string $errors */ $error_class = $errors->has('route_name') ? 'parsley-error ' : ''; ?>
        <label for="route_name" class="form-label font-weight-bold"><?php echo app('translator')->get('menu.label_route_name'); ?></label>
        <div class="form-group">
            <?php echo e(Form::text('route_name', null, ['class' => $error_class . 'form-control', 'id' => 'route_name', 'required' => false])); ?>

            <?php if($errors->has('route_name')): ?>
            <p class="text-danger"><?php echo e($errors->first('route_name')); ?></p>
            <?php endif; ?>
        </div>
    </div>

    <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 my-2">
        <?php /** @var string $errors */ $error_class = $errors->has('icon') ? 'parsley-error ' : ''; ?>
        <label for="icon" class="form-label font-weight-bold"><?php echo app('translator')->get('menu.label_icon'); ?></label>
        <div class="form-group">
            <?php echo e(Form::text('icon', null, ['class' => $error_class . 'form-control', 'id' => 'icon', 'placeholder' => 'fa fa-bars'])); ?>

            <?php if($errors->has('icon')): ?>
            <p class="text-danger"><?php echo e($errors->first('icon')); ?></p>
            <?php endif; ?>
        </div>
    </div>

    <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 my-2">
        <?php /** @var string $errors */ $error_class = $errors->has('order_by') ? 'parsley-error ' : ''; ?>
        <label for="order_by" class="form-label font-weight-bold"><?php echo app('translator')->get('menu.label_order_by'); ?></label>
        <sup class="text-danger">*</sup>
        <div class="form-group">
            <?php echo e(Form::number('order_by', null, ['class' => $error_class . 'form-control', 'min' => 1, 'id' => 'order_by', 'required' => 1])); ?>

            <?php if($errors->has('order_by')): ?>
            <p class="text-danger"><?php echo e($errors->first('order_by')); ?></p>
            <?php endif; ?>
        </div>
    </div>

    

<div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 my-2">
    <?php /** @var string $errors */ $error_class = $errors->has('menu_type') ? 'parsley-error ' : ''; ?>
    <label for="menu_type" class="form-label font-weight-bold"><?php echo app('translator')->get('menu.label_menu_type'); ?></label>
    <sup class="text-danger">*</sup>
    <div class="form-group form-group-check pl-4">

        <div class="form-check-custom">
            <?php echo e(Form::radio('menu_type', 'Parent', null, ['class' => 'form-check-input', 'id' => 'menu_type_parent', 'required' => 1, 'checked' => @$menu->menu_type == 'Parent' ? true : ((!isset($menu->menu_type)) ? true : false )])); ?>

            <label class="form-check-label" for="menu_type_parent">
                <?php echo app('translator')->get('menu.label_menu_type_parent'); ?>
            </label>
        </div>

        <div class="form-check-custom">
            <?php echo e(Form::radio('menu_type', 'Module', null, ['class' => 'form-check-input', 'id' => 'menu_type_module', 'required' => 1, 'checked' => @$menu->menu_type == 'Module' ? true : false])); ?>

            <label class="form-check-label" for="menu_type_module">
                <?php echo app('translator')->get('menu.label_menu_type_module'); ?>
            </label>
        </div>

        <div class="form-check-custom">
            <?php echo e(Form::radio('menu_type', 'Single', null, ['class' => 'form-check-input', 'id' => 'menu_type_single', 'required' => 1, 'checked' => @$menu->menu_type == 'Single' ? true : false])); ?>

            <label class="form-check-label" for="menu_type_single">
                <?php echo app('translator')->get('menu.label_menu_type_single'); ?>
            </label>
        </div>

        <?php if($errors->has('menu_type')): ?>
        <p class="text-danger"><?php echo e($errors->first('menu_type')); ?></p>
        <?php endif; ?>
    </div>
</div>

<div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 my-2">
    <?php /** @var string $errors */ $error_class = $errors->has('create_permissions') ? 'parsley-error ' : ''; ?>
    <label for="create_permissions" class="form-label font-weight-bold"><?php echo app('translator')->get('menu.label_create_permissions'); ?></label>
    <sup class="text-danger">*</sup>
    <div class="form-group form-group-check pl-4">
        <div class="form-check-custom">
            <?php echo e(Form::radio('create_permissions', 'Yes', null, ['class' => 'form-check-input', 'id' => 'create_permissions_yes', 'required' => 1, 'checked' => @$menu->create_permissions == 'Yes' ? true : false])); ?>

            <label class="form-check-label" for="create_permissions_yes">
                <?php echo app('translator')->get('menu.label_create_permissions_yes'); ?>
            </label>
        </div>

        <div class="form-check-custom">
            <?php echo e(Form::radio('create_permissions', 'No', null, ['class' => 'form-check-input', 'id' => 'create_permissions_no', 'required' => 1, 'checked' => @$menu->create_permissions == 'Yes' ? false : true])); ?>

            <label class="form-check-label" for="create_permissions_no">
                <?php echo app('translator')->get('menu.label_create_permissions_no'); ?>
            </label>
        </div>
        <?php if($errors->has('create_permissions')): ?>
        <p class="text-danger"><?php echo e($errors->first('create_permissions')); ?></p>
        <?php endif; ?>
    </div>
</div>

<div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 my-2">
    <?php /** @var string $errors */ $error_class = $errors->has('is_hidden') ? 'parsley-error ' : ''; ?>
    <label for="is_hidden" class="form-label font-weight-bold"><?php echo app('translator')->get('menu.label_is_hidden'); ?></label>
    <sup class="text-danger">*</sup>
    <div class="form-group form-group-check pl-4">
        <div class="form-check-custom">
            <?php echo e(Form::radio('is_hidden', 'Yes', null, ['class' => 'form-check-input', 'id' => 'is_hidden_yes', 'required' => 1])); ?>

            <label class="form-check-label" for="is_hidden_yes">
                <?php echo app('translator')->get('menu.label_is_hidden_yes'); ?>
            </label>
        </div>

        <div class="form-check-custom">
            <?php echo e(Form::radio('is_hidden', 'No', null, ['class' => 'form-check-input', 'id' => 'is_hidden_no', 'required' => 1, 'checked' => @$menu->is_hidden == 'Yes' ? false : true])); ?>

            <label class="form-check-label" for="is_hidden_no">
                <?php echo app('translator')->get('menu.label_is_hidden_no'); ?>
            </label>
        </div>
        <?php if($errors->has('is_hidden')): ?>
        <p class="text-danger"><?php echo e($errors->first('is_hidden')); ?></p>
        <?php endif; ?>
    </div>
</div>

<div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 my-2">
    <?php /** @var string $errors */ $error_class = $errors->has('status') ? 'parsley-error ' : ''; ?>
    <label for="status" class="form-label font-weight-bold"><?php echo app('translator')->get('menu.label_status'); ?></label>
    <sup class="text-danger">*</sup>
    <div class="form-group form-group-check pl-4">
        <div class="form-check-custom">
            <?php echo e(Form::radio('status', '1', null, ['class' => 'form-check-input', 'id' => 'active', 'required' => 1, 'checked' => 1])); ?>

            <label class="form-check-label" for="active">
                <?php echo app('translator')->get('menu.label_status_active'); ?>
            </label>
        </div>

        <div class="form-check-custom">
            <?php echo e(Form::radio('status', '0', null, ['class' => 'form-check-input', 'id' => 'inactive', 'required' => 1])); ?>

            <label class="form-check-label" for="inactive">
                <?php echo app('translator')->get('menu.label_status_inactive'); ?>
            </label>
        </div>
        <?php if($errors->has('status')): ?>
        <p class="text-danger"><?php echo e($errors->first('status')); ?></p>
        <?php endif; ?>
    </div>
</div>

<br>
<br>
<br>
<br>
<br>
</div>


<h5 class="d-inline-block">
    <strong><?php echo app('translator')->get('menu.menu_actions'); ?></strong>
</h5>

<div class="border border-secondary mb-4 p-4">
    <div class="row">
        <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-sm-12 col-md-4 col-lg-3 my-2 <?php echo e($error_class); ?>">
            <label for="<?php echo e($action->slug); ?>" class="font-size-15 font-weight-semibold" for="create" style="cursor: pointer;">
                <?php echo e(Form::checkbox('actions[' . $action->slug . ']', 'yes', false, ['id' => $action->slug, 'class' => 'form-check-input'])); ?>

                <?php echo app('translator')->get('menu.' . $action->slug . '_action'); ?>
            </label>
            <?php if($errors->has($action->slug)): ?>
            <p class="text-danger"><?php echo e($errors->first($action->slug)); ?></p>
            <?php endif; ?>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php if(!@$menu): ?>
        <div class="col-sm-12 col-md-4 col-lg-3 my-2 <?php echo e($error_class); ?>">
            <label class="font-size-15 font-weight-semibold" for="deleted_list" style="cursor: pointer;">
                <?php echo e(Form::checkbox('actions[deleted_list]', 'yes', false, ['id' => 'deleted_list', 'class' => 'form-check-input'])); ?>

                <?php echo app('translator')->get('menu.deleted_list_action'); ?>
            </label>
            <?php if($errors->has('deleted_list')): ?>
            <p class="text-danger"><?php echo e($errors->first('deleted_list')); ?></p>
            <?php endif; ?>
        </div>
        <div class="col-sm-12 col-md-4 col-lg-3 my-2 <?php echo e($error_class); ?>">
            <label class="font-size-15 font-weight-semibold" for="restore" style="cursor: pointer;">
                <?php echo e(Form::checkbox('actions[restore]', 'yes', false, ['id' => 'restore', 'class' => 'form-check-input'])); ?>

                <?php echo app('translator')->get('menu.restore_action'); ?>
            </label>
            <?php if($errors->has('restore')): ?>
            <p class="text-danger"><?php echo e($errors->first('restore')); ?></p>
            <?php endif; ?>
        </div>
        <div class="col-sm-12 col-md-4 col-lg-3 my-2 <?php echo e($error_class); ?>">
            <label class="font-size-15 font-weight-semibold" for="permanent_delete" style="cursor: pointer;">
                <?php echo e(Form::checkbox('actions[permanent_delete]', 'yes', false, ['id' => 'permanent_delete', 'class' => 'form-check-input'])); ?>

                <?php echo app('translator')->get('menu.permanent_delete_action'); ?>
            </label>
            <?php if($errors->has('permanent_delete')): ?>
            <p class="text-danger"><?php echo e($errors->first('permanent_delete')); ?></p>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
</div>


<div class="row">
    <div class="col-md-12 text-right">
        <button type="submit" class="btn btn-primary waves-effect waves-light">
            <i class="fa fa-save"></i> <?php echo app('translator')->get('menu.label_submit_button'); ?>
        </button>
    </div>
</div>

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(URL::asset('/assets/common/libs/parsleyjs/parsleyjs.min.js')); ?>"></script>

<script src="<?php echo e(URL::asset('/assets/common/js/pages/form-validation.init.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/gzmcfenigov/public_html/resources/views/menu/form.blade.php ENDPATH**/ ?>